 /*
+----------------------------------------------------------------------------------------------+
| Copyright ©<2021 Feb>  < just.trader@yahoo.com >
| 
| Created at the request of @subterfuge
 https://futures.io/elite-circle/1261-want-your-ninjatrader-indicator-created-free-1656.html#post830633
 
 Updated 2021 Mar 13:  Added KAMA to the list of available Moving Averages (per @Angelo1). Also added MAMA
 Updated 2021 Feb 13:  Added VMA to the list of available Moving Averages (per @guidoisot)
 Updated 2021 Feb 11:  Allowed selection of different type of fast from slow moving average for cross over
+----------------------------------------------------------------------------------------------+
 */
#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

namespace NinjaTrader.NinjaScript.Indicators
{
	/// <summary>
	/// Chart Panel background coloring when moving averages cross
	/// </summary>
	public class jprMovingAverageCrossOverBC : Indicator
	{
		private Series<double> 		maFast;
		private Series<double> 		maSlow;
		

		private int 				barsCrossedDn = 0;
		private int 				barsCrossedUp = 0;
		private double				higherHi;
		private double				lowerLo;
		private double				bgOpacity = 50;
		
		
		private Brush 				downColor;		
		private Brush 				upColor ;
		

		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description					= "Moving Average Cross Over Background Coloring";
				Name						= "jprMovingAverageCrossOverBC";
				IsOverlay					= true;
				IsSuspendedWhileInactive	= true;
				
				MAfastType						= MyMovingAverage.EMA;
				MAslowType						= MyMovingAverage.EMA;
				PeriodFast					= 8;
				PeriodSlow					= 13;
				PeriodVMAvolatilityFast		= 8;
				PeriodVMAvolatilitySlow		= 13;
				PeriodKAMAfast				= 2;
				PeriodKAMAslow				= 30;
				LimitMAMAfast				= 0.5;
				LimitMAMAslow				= 0.05;
				
				BarsDelay					= 2;
				
				PanelColorCrossBelow		= Brushes.PaleVioletRed;
				PanelColorCrossAbove		= Brushes.PaleGreen;
				BackgroundOpacity			= 20;
				OutlineOpacity				= 70;
				
				ShowBackGroundShading		= true;
				ShowCrossingRectangle		= false;
				ShowMovingAverages			= false;
				
				AddPlot(Brushes.Cyan, "MAfast");
				AddPlot(Brushes.Gray, "MAslow");
			}
			else if (State == State.Configure)
			{
				maFast 	= new Series<double>(this);
				maSlow 	= new Series<double>(this);
				
				
				Brush tempDnOutline 	= PanelColorCrossBelow.Clone();	// Create a temporary copy of the user created Brush PanelColorCrossAbove			
				tempDnOutline.Opacity 	= OutlineOpacity / 100.0; 		// Valid values are 0 to 1
				tempDnOutline.Freeze(); 								// freeze the brush (required)
				downColor 				= (Brush)tempDnOutline;			// assign the temp brush to the brush that will be used later in OnBarUpdate
				
				Brush tempUpOutline 	= PanelColorCrossAbove.Clone();	// Create a temporary copy of the user created Brush PanelColorCrossAbove			
				tempUpOutline.Opacity 	= OutlineOpacity / 100.0; 
				tempUpOutline.Freeze(); 								// freeze the brush (required)
				upColor 				= (Brush)tempUpOutline;			// assign the temp brush to the brush that will be used later in OnBarUpdate

				
				
				bgOpacity 	= BackgroundOpacity / 100.0; 

				Brush tempDn = PanelColorCrossBelow.Clone();	// Create a temporary copy of the user created Brush PanelColorCrossAbove
				tempDn.Opacity = bgOpacity; 	// set the desired opacity
				tempDn.Freeze(); 								// freeze the brush (required)
				PanelColorCrossBelow = tempDn; 					// assign the temp brush to the brush that will be used later in OnBarUpdate

				Brush tempUp = PanelColorCrossAbove.Clone();	// Create a temporary copy of the user created Brush PanelColorCrossAbove
				tempUp.Opacity = bgOpacity; 	// set the desired opacity
//				tempUp.Opacity = BackgroundOpacity / 100.0; 	// set the desired opacity
				tempUp.Freeze(); 								// freeze the brush (required)
				PanelColorCrossAbove = tempUp; 					// assign the temp brush to the brush that will be used later in OnBarUpdate

			}
			else if (State == State.DataLoaded)
			{
			}
		}

		protected override void OnBarUpdate()
		{
			SetFastMovingAverages();
			SetSlowMovingAverages();
			
			if (ShowMovingAverages)
			{
				Values[0][0] = maFast[0];
				Values[1][0] = maSlow[0];
			}
						
			MovingAverageCross();
			SetMAcrossedColor();
		}
		
		
	
		private void MovingAverageCross()
		{
			if (CrossAbove(maFast, maSlow, 1))
			{
				++barsCrossedUp;
				barsCrossedDn = 0;
				higherHi 	  = High[0];						

			}
			else if (CrossBelow(maFast, maSlow, 1))
			{
				++barsCrossedDn;
				barsCrossedUp = 0;
				lowerLo		  = Low[0];							
			}
		}		
		
		
		
		private void SetMAcrossedColor()
		{
			if (barsCrossedUp > 0)
			{
				if (barsCrossedUp >= BarsDelay)
				{
					if (ShowBackGroundShading)					
						BackBrush = PanelColorCrossAbove;
					if (ShowCrossingRectangle)
					{
						if (High[0] > higherHi)
							higherHi = High[0];
						Draw.Rectangle(this, "upCrossed", false, (barsCrossedUp-BarsDelay), higherHi, (barsCrossedUp-BarsDelay > 0 ? 0 : -1), Low[(barsCrossedUp-BarsDelay)], upColor, PanelColorCrossAbove, BackgroundOpacity);	
					}
				}
				++barsCrossedUp;
			}
			else if (barsCrossedDn > 0)
			{
				if (barsCrossedDn >= BarsDelay)
				{
					if (ShowBackGroundShading)		
						BackBrush = PanelColorCrossBelow;
					if (ShowCrossingRectangle)
					{
						if (Low[0] < lowerLo)
							lowerLo = Low[0];
						Draw.Rectangle(this, "downCrossed", false, (barsCrossedDn-BarsDelay), High[(barsCrossedDn-BarsDelay)],  (barsCrossedUp-BarsDelay > 0 ? 0 : -1), lowerLo, downColor, PanelColorCrossBelow, BackgroundOpacity);							
					}
				}
				++barsCrossedDn;
			}

		}		
	

		
		#region CODE to get MA Values
		private void SetFastMovingAverages()
		{
//			Print(Time+"    MA type --- ="+MAfastType);
			switch (MAfastType) //Get MA1 Value
//			switch (MAfastType) //Get MA1 Value
			{
				// If the maType is defined as an EMA then...
				case MyMovingAverage.EMA:
				{
					// Sets the plot to be equal to the EMA's plot
					maFast[0] = EMA(Input, PeriodFast)[0];
					break;
				}
				
				// If the maType is defined as a HMA then...
				case MyMovingAverage.HMA:
				{
					// Sets the plot to be equal to the HMA's plot
					maFast[0] = HMA(Input, PeriodFast)[0];
					break;
				}
				
				// If the maType is defined as a SMA then...
				case MyMovingAverage.SMA:
				{
					// Sets the plot to be equal to the SMA's plot
					maFast[0] = SMA(Input, PeriodFast)[0];
					break;
				}
				
				// If the maType is defined as a WMA then...
				case MyMovingAverage.WMA:
				{
					// Sets the plot to be equal to the WMA's plot
					maFast[0] = WMA(Input, PeriodFast)[0];
					break;
				}
				
				// If the maType is defined as a DEMA then...
				case MyMovingAverage.DEMA:
				{
					// Sets the plot to be equal to the DEMA's plot
					maFast[0] = DEMA(Input, PeriodFast)[0];
					break;
				}
				
				// If the maType is defined as a TMA then...
				case MyMovingAverage.TMA:
				{
					// Sets the plot to be equal to the TMA's plot
					maFast[0] = TMA(Input, PeriodFast)[0];
					break;
				}
				
				
				// If the maType is defined as a TEMA then...
				case MyMovingAverage.TEMA:
				{
					// Sets the plot to be equal to the TMA's plot
					maFast[0] = TEMA(Input, PeriodFast)[0];
					break;
				}
				
				// If the maType is defined as a ZLEMA then...
				case MyMovingAverage.ZLEMA:
				{
					// Sets the plot to be equal to the ZLEMA's plot
					maFast[0] = ZLEMA(Input, PeriodFast)[0];
					break;
				}
				
				// If the maType is defined as a VMA then...
				case MyMovingAverage.VMA:
				{
					// Sets the plot to be equal to the VMA's plot
					maFast[0] = VMA(PeriodFast, PeriodVMAvolatilityFast)[0];
//					maFast[0] = VMA(Input, PeriodFast)[0];
					break;
				}
				
				// If the maType is defined as a KAMA then...
				case MyMovingAverage.KAMA:
				{
					// Sets the plot to be equal to the KAMA's plot
					maFast[0] = KAMA(PeriodKAMAfast, PeriodFast, PeriodKAMAslow)[0];
					break;
				}
				
				// If the maType is defined as a MAMA then...
				case MyMovingAverage.MAMA:
				{
					// Sets the plot to be equal to the MAMA's plot
					maFast[0] = MAMA(LimitMAMAfast, LimitMAMAslow).Default[0];
					break;
				}
				
			}
		}
		
		
		private void SetSlowMovingAverages()
		{
//			Print(Time+"    MA type --- ="+MAslowType);
			switch (MAslowType) //Get MA1 Value
//			switch (MAslowType) //Get MA1 Value
			{
				// If the maType is defined as an EMA then...
				case MyMovingAverage.EMA:
				{
					// Sets the plot to be equal to the EMA's plot
					maSlow[0] = EMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a HMA then...
				case MyMovingAverage.HMA:
				{
					// Sets the plot to be equal to the HMA's plot
					maSlow[0] = HMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a SMA then...
				case MyMovingAverage.SMA:
				{
					// Sets the plot to be equal to the SMA's plot
					maSlow[0] = SMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a WMA then...
				case MyMovingAverage.WMA:
				{
					// Sets the plot to be equal to the WMA's plot
					maSlow[0] = WMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a DEMA then...
				case MyMovingAverage.DEMA:
				{
					// Sets the plot to be equal to the DEMA's plot
					maSlow[0] = DEMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a TMA then...
				case MyMovingAverage.TMA:
				{
					// Sets the plot to be equal to the TMA's plot
					maSlow[0] = TMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a TEMA then...
				case MyMovingAverage.TEMA:
				{
					// Sets the plot to be equal to the TEMA's plot
					maSlow[0] = TEMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a ZLEMA then...
				case MyMovingAverage.ZLEMA:
				{
					// Sets the plot to be equal to the ZLEMA's plot
					maSlow[0] = ZLEMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a VMA then...
				case MyMovingAverage.VMA:
				{
					// Sets the plot to be equal to the VMA's plot
					maSlow[0] = VMA(PeriodSlow, PeriodVMAvolatilitySlow)[0];
//					maFast[0] = VMA(Input, PeriodSlow)[0];
					break;
				}
				
				// If the maType is defined as a KAMA then...
				case MyMovingAverage.KAMA:
				{
					// Sets the plot to be equal to the KAMA's plot
					maSlow[0] = KAMA(PeriodKAMAfast, PeriodSlow, PeriodKAMAslow)[0];
					break;
				}
				
				// If the maType is defined as a MAMA then...
				case MyMovingAverage.MAMA:
				{
					// Sets the plot to be equal to the MAMA's plot
					maSlow[0] = MAMA(LimitMAMAfast, LimitMAMAslow).Fama[0];
					break;
				}

			}
		}
		
			#endregion		
		
		

		#region Properties
		[Display(Name = "Fasr Average Type", Description="Crossing Fast Moving Average Type", GroupName = "Crossing Parameters", Order = 0)]
		public MyMovingAverage MAfastType
		{ get; set; }

		[Display(Name = "Slow Average Type", Description="Crossing Moving Slow Average Type", GroupName = "Crossing Parameters", Order = 1)]
		public MyMovingAverage MAslowType
		{ get; set; }

		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period Fast MA", Description = "Fast Moving Average Period", GroupName = "Crossing Parameters", Order = 2)]
		public int PeriodFast
		{ get; set; }
		
		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period Slow MA", Description = "Slow Moving Average Period", GroupName = "Crossing Parameters", Order = 3)]
		public int PeriodSlow
		{ get; set; }
				
		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Bars Delay", Description = "Number of Bars delayed after Moving Averages cross", GroupName = "Crossing Parameters", Order = 4)]
		public int BarsDelay
		{ get; set; }
		
		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period Volatility Fast VMA", Description = "Fast Variable Moving Average Volatility Period", GroupName = "Crossing Parameters VMA Add", Order = 5)]
		public int PeriodVMAvolatilityFast
		{ get; set; }
		
		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period Volatility Slow VMA", Description = "Slow Variable Moving Average Volatility Period", GroupName = "Crossing Parameters VMA Add", Order = 6)]
		public int PeriodVMAvolatilitySlow
		{ get; set; }
		
		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period Fast KAMA", Description = "Fast KAMA Parameter Period", GroupName = "Crossing Parameters KAMA Add", Order = 5)]
		public int PeriodKAMAfast
		{ get; set; }
		
		[Range(1, int.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period Slow KAMA", Description = "Slow KAMA Parameter Period", GroupName = "Crossing Parameters KAMA Add", Order = 6)]
		public int PeriodKAMAslow
		{ get; set; }
		
		[Range(0, double.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period Fast KAMA", Description = "Fast MAMA Parameter Limit", GroupName = "Crossing Parameters MAMA Add", Order = 5)]
		public double LimitMAMAfast
		{ get; set; }
		
		[Range(0, double.MaxValue), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Period Slow KAMA", Description = "Slow MAMA Parameter Limit", GroupName = "Crossing Parameters MAMA Add", Order = 6)]
		public double LimitMAMAslow
		{ get; set; }
				
		
		// display
		[NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Shade Background at Cross", Description = "Shade Background after Moving Average crossed ", GroupName="Background Parameters", Order = 0)]
		public bool ShowBackGroundShading
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Draw Rectangle at Cross", Description = "Draw Rectangle after Moving Average crossed ", GroupName = "Rectangle Parameters", Order = 0)]
		public bool ShowCrossingRectangle
		{ get; set; }
		
		[NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "Draw Moving Averages", Description = "Draw Crossing Moving Averages",  GroupName = "Crossing Parameters", Order = 5)]
		public bool ShowMovingAverages
		{ get; set; }
		
		
//		[Range(0, double.MaxValue), NinjaScriptProperty]
		[Range(0, 100), NinjaScriptProperty]
//		[Range(0, 1.0), NinjaScriptProperty]
		[Display(ResourceType = typeof(Custom.Resource), Name = "% Outline Opacity", Description = "Percent Rectangle Color Opacity", GroupName = "Rectangle Parameters", Order = 4)]
		public int OutlineOpacity
		{ get; set; }
		
		
		[Range(1, 100)]
		[Display(Name=" % Background Opacity", Description="Sets the amount of opacity of background colors ", Order=31, GroupName="Background Parameters")]
		public int BackgroundOpacity
		{ get; set; }

		[XmlIgnore]
		[Display(Name="Color for Cross Above", Description="Panel background color when crossing above", Order=32, GroupName="Background Parameters")]
		public Brush PanelColorCrossAbove
		{ get; set; }

		[Browsable(false)]
		public string PanelColorCrossAboveSerializable
		{
			get { return Serialize.BrushToString(PanelColorCrossAbove); }
			set { PanelColorCrossAbove = Serialize.StringToBrush(value); }
		}


		[XmlIgnore]
		[Display(Name="Color for Cross Below", Description="Panel background color when crossing below", Order=33, GroupName="Background Parameters")]
		public Brush PanelColorCrossBelow
		{ get; set; }

		[Browsable(false)]
		public string PanelColorCrossBelowSerializable
		{
			get { return Serialize.BrushToString(PanelColorCrossBelow); }
			set { PanelColorCrossBelow = Serialize.StringToBrush(value); }
		}

		#endregion
		
		
		#region Enums
		public enum MyMovingAverage 
		{
			EMA,
			SMA,
			HMA,
			WMA,
			DEMA,
			TMA,
			TEMA,
			ZLEMA,
			VMA,
			KAMA,
			MAMA,
		}
		#endregion
		
	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private jprMovingAverageCrossOverBC[] cachejprMovingAverageCrossOverBC;
		public jprMovingAverageCrossOverBC jprMovingAverageCrossOverBC(int periodFast, int periodSlow, int barsDelay, int periodVMAvolatilityFast, int periodVMAvolatilitySlow, int periodKAMAfast, int periodKAMAslow, double limitMAMAfast, double limitMAMAslow, bool showBackGroundShading, bool showCrossingRectangle, bool showMovingAverages, int outlineOpacity)
		{
			return jprMovingAverageCrossOverBC(Input, periodFast, periodSlow, barsDelay, periodVMAvolatilityFast, periodVMAvolatilitySlow, periodKAMAfast, periodKAMAslow, limitMAMAfast, limitMAMAslow, showBackGroundShading, showCrossingRectangle, showMovingAverages, outlineOpacity);
		}

		public jprMovingAverageCrossOverBC jprMovingAverageCrossOverBC(ISeries<double> input, int periodFast, int periodSlow, int barsDelay, int periodVMAvolatilityFast, int periodVMAvolatilitySlow, int periodKAMAfast, int periodKAMAslow, double limitMAMAfast, double limitMAMAslow, bool showBackGroundShading, bool showCrossingRectangle, bool showMovingAverages, int outlineOpacity)
		{
			if (cachejprMovingAverageCrossOverBC != null)
				for (int idx = 0; idx < cachejprMovingAverageCrossOverBC.Length; idx++)
					if (cachejprMovingAverageCrossOverBC[idx] != null && cachejprMovingAverageCrossOverBC[idx].PeriodFast == periodFast && cachejprMovingAverageCrossOverBC[idx].PeriodSlow == periodSlow && cachejprMovingAverageCrossOverBC[idx].BarsDelay == barsDelay && cachejprMovingAverageCrossOverBC[idx].PeriodVMAvolatilityFast == periodVMAvolatilityFast && cachejprMovingAverageCrossOverBC[idx].PeriodVMAvolatilitySlow == periodVMAvolatilitySlow && cachejprMovingAverageCrossOverBC[idx].PeriodKAMAfast == periodKAMAfast && cachejprMovingAverageCrossOverBC[idx].PeriodKAMAslow == periodKAMAslow && cachejprMovingAverageCrossOverBC[idx].LimitMAMAfast == limitMAMAfast && cachejprMovingAverageCrossOverBC[idx].LimitMAMAslow == limitMAMAslow && cachejprMovingAverageCrossOverBC[idx].ShowBackGroundShading == showBackGroundShading && cachejprMovingAverageCrossOverBC[idx].ShowCrossingRectangle == showCrossingRectangle && cachejprMovingAverageCrossOverBC[idx].ShowMovingAverages == showMovingAverages && cachejprMovingAverageCrossOverBC[idx].OutlineOpacity == outlineOpacity && cachejprMovingAverageCrossOverBC[idx].EqualsInput(input))
						return cachejprMovingAverageCrossOverBC[idx];
			return CacheIndicator<jprMovingAverageCrossOverBC>(new jprMovingAverageCrossOverBC(){ PeriodFast = periodFast, PeriodSlow = periodSlow, BarsDelay = barsDelay, PeriodVMAvolatilityFast = periodVMAvolatilityFast, PeriodVMAvolatilitySlow = periodVMAvolatilitySlow, PeriodKAMAfast = periodKAMAfast, PeriodKAMAslow = periodKAMAslow, LimitMAMAfast = limitMAMAfast, LimitMAMAslow = limitMAMAslow, ShowBackGroundShading = showBackGroundShading, ShowCrossingRectangle = showCrossingRectangle, ShowMovingAverages = showMovingAverages, OutlineOpacity = outlineOpacity }, input, ref cachejprMovingAverageCrossOverBC);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.jprMovingAverageCrossOverBC jprMovingAverageCrossOverBC(int periodFast, int periodSlow, int barsDelay, int periodVMAvolatilityFast, int periodVMAvolatilitySlow, int periodKAMAfast, int periodKAMAslow, double limitMAMAfast, double limitMAMAslow, bool showBackGroundShading, bool showCrossingRectangle, bool showMovingAverages, int outlineOpacity)
		{
			return indicator.jprMovingAverageCrossOverBC(Input, periodFast, periodSlow, barsDelay, periodVMAvolatilityFast, periodVMAvolatilitySlow, periodKAMAfast, periodKAMAslow, limitMAMAfast, limitMAMAslow, showBackGroundShading, showCrossingRectangle, showMovingAverages, outlineOpacity);
		}

		public Indicators.jprMovingAverageCrossOverBC jprMovingAverageCrossOverBC(ISeries<double> input , int periodFast, int periodSlow, int barsDelay, int periodVMAvolatilityFast, int periodVMAvolatilitySlow, int periodKAMAfast, int periodKAMAslow, double limitMAMAfast, double limitMAMAslow, bool showBackGroundShading, bool showCrossingRectangle, bool showMovingAverages, int outlineOpacity)
		{
			return indicator.jprMovingAverageCrossOverBC(input, periodFast, periodSlow, barsDelay, periodVMAvolatilityFast, periodVMAvolatilitySlow, periodKAMAfast, periodKAMAslow, limitMAMAfast, limitMAMAslow, showBackGroundShading, showCrossingRectangle, showMovingAverages, outlineOpacity);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.jprMovingAverageCrossOverBC jprMovingAverageCrossOverBC(int periodFast, int periodSlow, int barsDelay, int periodVMAvolatilityFast, int periodVMAvolatilitySlow, int periodKAMAfast, int periodKAMAslow, double limitMAMAfast, double limitMAMAslow, bool showBackGroundShading, bool showCrossingRectangle, bool showMovingAverages, int outlineOpacity)
		{
			return indicator.jprMovingAverageCrossOverBC(Input, periodFast, periodSlow, barsDelay, periodVMAvolatilityFast, periodVMAvolatilitySlow, periodKAMAfast, periodKAMAslow, limitMAMAfast, limitMAMAslow, showBackGroundShading, showCrossingRectangle, showMovingAverages, outlineOpacity);
		}

		public Indicators.jprMovingAverageCrossOverBC jprMovingAverageCrossOverBC(ISeries<double> input , int periodFast, int periodSlow, int barsDelay, int periodVMAvolatilityFast, int periodVMAvolatilitySlow, int periodKAMAfast, int periodKAMAslow, double limitMAMAfast, double limitMAMAslow, bool showBackGroundShading, bool showCrossingRectangle, bool showMovingAverages, int outlineOpacity)
		{
			return indicator.jprMovingAverageCrossOverBC(input, periodFast, periodSlow, barsDelay, periodVMAvolatilityFast, periodVMAvolatilitySlow, periodKAMAfast, periodKAMAslow, limitMAMAfast, limitMAMAslow, showBackGroundShading, showCrossingRectangle, showMovingAverages, outlineOpacity);
		}
	}
}

#endregion
